//
//  CooperViewController.swift
//  ClassDemo17-Motion
//
//  Created by bulko on 8/8/25.
//  Copyright © 2025 bulko. All rights reserved.
//

import UIKit
import CoreMotion

class CooperViewController: UIViewController {

    @IBOutlet weak var cooperImageView: UIImageView!
    
    let motionManager = CMMotionManager()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        motionManager.deviceMotionUpdateInterval = 0.1
        
        motionManager.startDeviceMotionUpdates(to: OperationQueue.current!) {
            (deviceMotion, error) in
            
            if (error == nil) {
                self.handleDeviceMotionUpdate(deviceMotion: deviceMotion!)
            } else {
                print("Error occurred")
            }
        }
    }

    func handleDeviceMotionUpdate(deviceMotion:CMDeviceMotion) {
        
        let gravity = deviceMotion.gravity
        let rotation = atan2(gravity.x,gravity.y) + Double.pi
        self.cooperImageView.transform = CGAffineTransform(rotationAngle: CGFloat(rotation))
        
    }
    
}
